using System;

namespace Klasy
{
	class Ulamek_Exception : Exception
	{
		private String message;
		public Ulamek_Exception(String amessage) {message=amessage;}
		public String what() {return message;}
	}

	public class Ulamek
	{
		private int licznik,mianownik;

		public static readonly Ulamek Zero=new Ulamek(0,1);
		public static readonly Ulamek Jeden=new Ulamek(1,1);
		public static readonly Ulamek Polowa=new Ulamek(1,2);
		public static readonly Ulamek Cwierc=new Ulamek(1,4);

		public Ulamek(int alicznik,int amianownik)
			{
			set(alicznik,amianownik);
			}

		//cos podobnego do konstruktora copy w C++
		public Ulamek(Ulamek aulamek)
			{
			int olicznik,omianownik;
			aulamek.get(out olicznik,out omianownik);
			set(olicznik,omianownik);
			}

		//analog clone() w Javie
		public Ulamek Clone()
			{
			return new Ulamek(licznik,mianownik);
			}

		public void set(int alicznik,int amianownik)
			{
			//if (amianownik==0) return false;
			if (amianownik==0) throw new Ulamek_Exception("Ulamek: Blad #1");
			licznik=alicznik;
			mianownik=amianownik;
			}

		//public void get(ref int rlicznik,ref int rmianownik) //w ref wartosc zmiennej nie musi byc zmieniona
		public void get(out int rlicznik,out int rmianownik) //w out wartosc zmiennej musi byc zmieniona
			{
			rlicznik=licznik;
			rmianownik=mianownik;
			}		

		public void get(int[] arg)
			{
			arg[0]=licznik;
			arg[1]=mianownik;
			}

		public int[] get()
			{
			int[] wynik=new int[2];
			wynik[0]=licznik;
			wynik[1]=mianownik;
			return wynik;
			}
	}
}
